// Original image: Ch1 DAPI, Ch2 BrdU, Ch3 GFAP. 
// The results were transferred to Excel for sorting, before analysis in Graphpad.

name=getInfo("image.filename"); 

run("Arrange Channels...", "new=132");

run("Colors...", "foreground=white background=black selection=yellow");

//Auto-segmentation
setAutoThreshold("Default dark");
setOption("BlackBackground", true);
run("Convert to Mask", "method=Default background=Dark calculate black");


//Area-selection measurment 
run("Select All");
run("Measure");
run("Select None");

run("Split Channels");

selectWindow("C1-"+name+"");
run("Analyze Particles...", "size=20-Infinity show=Masks display=Nothing slice");
run("Blue");
rename("DAPI-"+name+"");
selectWindow("C1-"+name+"");
close();

selectWindow("C2-"+name+"");
run("Analyze Particles...", "size=50-Infinity show=Masks slice");
run("Green");
rename("GFAP-"+name+"");
selectWindow("C2-"+name+"");
close();

selectWindow("C3-"+name+"");
run("Analyze Particles...", "size=20-Infinity circularity=0.2-1.00 show=Masks slice");
run("Red");
rename("BrdU-"+name+"");
selectWindow("C3-"+name+"");
close();

//Remove DAPInegative BrdU
selectWindow("DAPI-"+name+"");
run("Create Selection");
roiManager("Add");
selectWindow("BrdU-"+name+"");
roiManager("Select", 0);
run("Clear Outside", "slice");
run("Select None");

//DAPI and BrdU + GFAP
selectWindow("BrdU-"+name+"");
run("Create Selection"); 
roiManager("Add"); 
selectWindow("GFAP-"+name+"");
run("Duplicate...", "duplicate");
rename("BrdU+GFAP+-"+name+"");
roiManager("Select", 0);
run("Clear Outside", "slice");
roiManager("Delete");

//Measurements
selectWindow("BrdU-"+name+"");
run("Select None");
run("Analyze Particles...", "size=1-Infinity show=Nothing display slice");

selectWindow("GFAP-"+name+"");
run("Select None");
run("Analyze Particles...", "size=1-Infinity show=Nothing display slice");

selectWindow("DAPI-"+name+"");
run("Select None");
run("Analyze Particles...", "size=1-Infinity show=Nothing display slice");
 
selectWindow("BrdU+GFAP+-"+name+"");
run("Select None");
run("Analyze Particles...", "size=10-Infinity circularity=0.3-1.00 show=Masks display")run("Green");
rename("GFAP+BrdU+-"+name+"");
selectWindow("BrdU+GFAP+-"+name+"");
close();

run("Images to Stack", "name="+name+" title=[] use");
run("Make Composite", "display=Composite");
run("Blue");
setSlice(2); 
run("Green"); 
setSlice(3); 
run("Magenta");
setSlice(4); 
run("Yellow"); 
 


//To see the analysed images and steps, stop here. The images labeled "masks of..." represent the objects analysed in the results. 

//Troubleshoot issues: Make sure the results show labels. As the script uses selection to mask over images make sure the "clear outside"-step in the script actually clears what is defined as outside the wanted selection - this has been issue when using the script between different computers. 
